/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.persist.PersistableRequestBody;
import com.ibm.hwmca.fw.util.Trace;

class OfferReply
implements RbfReply {
    private static final String TRACE_MASKT = "XRBFOMRT";
    private static final String TRACE_MASKF = "XRBFOMRF";
    private static final String TRACE_MASKD = "XRBFOMRD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-OfferRpy");
    private static final long serialVersionUID = -1457507292715968017L;
    private RbfRequestId requestId;
    private int status;
    private byte[] bodyEncoding;
    static final int STATUS_HANDLE = 0;
    static final int STATUS_DO_NOT_HANDLE = 4;
    static final int STATUS_CANCELED = 6;

    OfferReply(RbfRequestId requestId, int status) {
        if (requestId == null) {
            throw new IllegalArgumentException("Null request identifier specified");
        }
        if (!this.isValidStatus(status)) {
            throw new IllegalArgumentException("Invalid status specified");
        }
        this.requestId = requestId;
        this.status = status;
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    OfferReply(RbfRequest request, int status) throws PersistenceException {
        if (request == null) {
            throw new IllegalArgumentException("Null request specified");
        }
        if (!this.isValidStatus(status)) {
            throw new IllegalArgumentException("Invalid status specified");
        }
        this.requestId = request.getIdentifier();
        this.status = status;
        if (request.getBody() != null) {
            try {
                PersistenceManager pm = PersistenceManager.getPersistenceManager();
                this.bodyEncoding = PersistenceManager.encode(new PersistableRequestBody(request));
            }
            catch (PersistenceException pe) {
                String desc = pe.getClass().getName() + " encoding " + request.getBody().getClass().getName() + " " + this.requestId + ":\n" + RbfUtils.getStackTrace(pe);
                Trace.trace(TRACE_MASKF, desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1056);
                fl.add(desc);
                fl.add(RbfUtils.getLoggingInfo(request));
                fl.log();
                throw pe;
            }
        }
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    boolean isValidStatus(int status) {
        switch (status) {
            case 0: {
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                return true;
            }
        }
        return false;
    }

    RbfRequestId getRequestId() {
        return this.requestId;
    }

    int getStatus() {
        return this.status;
    }

    byte[] getRequestBodyEncoding() {
        return this.bodyEncoding;
    }

    public void process(MachineId sender2, int protocol) {
        Trace.trace(TRACE_MASKT, "-> process()");
        Trace.trace(TRACE_MASKT, "<- process()");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[OfferReply: reqId=" + this.requestId + ", status=" + this.status + ", ");
        if (this.bodyEncoding != null) {
            sb.append("bodyEncoding=yes");
        } else {
            sb.append("bodyEncoding=null");
        }
        sb.append("]");
        return sb.toString();
    }
}

